<?php 
foreach ($args['posts'] as $testimonial) { ?>
	<?php if ( isset( $testimonial['testimonial'] ) ) { ?>
	<div class="container1 content5 style-3 two-cols testimonial-id-<?php echo $testimonial['id']; ?>" itemscope itemtype="http://schema.org/Review">
		<div itemprop="itemReviewed" itemscope itemtype="http://schema.org/Organization">
			<meta itemprop="name" content="<?php bloginfo( 'name' ); ?>" />
			<meta itemprop="url" content="<?php bloginfo( 'url' ); ?>" />
		</div>	
		<?php if ( isset( $testimonial['title'] ) && $args['show_title'] == 1 ) { ?>
			<h4 itemprop="name"><?php echo $testimonial['title']; ?></h4>
		<?php } ?>
		<div class="box-wrapper"<?php if (!empty($args['color_scheme'])) echo ' style="background: '.$args['color_scheme'].';"'; ?>>
			<div class="container1-right">
				<?php if ( !empty( $args['show_image'] ) ) { ?>
					<?php if ( isset( $testimonial['image'] ) ) { ?>
						<img src="<?php echo $testimonial['image']; ?>" style="border-radius: 50%;" alt="">
					<?php } ?>
				<?php } ?>
			
				<div class="author_wrap" itemprop="author" itemscope itemtype="http://schema.org/Person">
			
				<?php if ( !empty( $testimonial['name'] ) ) { ?>
					<div class="author-name" itemprop="name"><?php echo $testimonial['name']; ?></div>
				<?php } ?>
				<?php if ( !empty( $testimonial['position'] ) && !empty( $args['show_position'] ) ) { ?>
					<?php if ( !empty( $testimonial['link'] ) ) { ?>
						<div class="author-work" itemprop="jobTitle"><a href="<?php echo $testimonial['link']; ?>" itemprop="url" target="_blank" rel="nofollow"><?php echo $testimonial['position']; ?></a></div>
					<?php } else { ?>
						<div class="author-work" itemprop="jobTitle"><?php echo $testimonial['position']; ?></div>
					<?php } ?>
				<?php } ?>
				</div>

				<?php if ( !empty( $args['show_rating'] ) && !empty( $testimonial['rating'] ) ) { ?>
					<div class="rating" itemprop="reviewRating" itemscope itemtype="http://schema.org/Rating">
						<span class="value-title" title="<?php echo $testimonial['rating']; ?>"></span> 
						<?php echo mts_testimonials_get_rating_html( $testimonial['rating'] ); ?>
						<meta itemprop="ratingValue" content="<?php echo $testimonial['rating']; ?>" />
					</div>
				<?php } ?>	
			</div>
			<p class="quotes" itemprop="reviewBody"<?php if (!empty($args['color_scheme'])) echo ' style="background: '.$args['color_scheme'].'; border-color: rgba(0, 0, 0, 0) '.$args['color_scheme'].';"'; ?>><?php echo $testimonial['testimonial']; ?></p>
		</div>		
	</div>
	<?php } ?>
<?php } ?>